var serverURL = "http://localhost:3000";
var maxLogEntries = 300;

var socket;
var io = null;


window.addEvent('domready', function()
{
	adjustEventHandler();
	autoSocketConnect();
});

function adjustEventHandler()
{
	if(!Browser.Platform.ios && !Browser.Platform.android)
	{
		var buttons = $("controller").getElements("button");
		for(var i = 0; i < buttons.length; i++)
		{
			var button = buttons[i];
			button.setProperty("onclick", button.getProperty("ontouchend"));
		}
		
		buttons = $("simulator").getElements("button");
		for(var j = 0; j < buttons.length; j++)
		{
			var button = buttons[j];
			button.setProperty("onclick", button.getProperty("ontouchend"));
		}
		
		console.log("added click event pass through to buttons.");
	}
}

function autoSocketConnect()
{
	serverURL = document.location.href;
	
	if(io == null || io == undefined)
	{
		var socketIOScript = new Element("script", {"src":serverURL + "socket.io/socket.io.js"});
		socketIOScript.addEvent("load", connectSocket);
		socketIOScript.inject(document.head);
		console.log("io not loaded, but will try loading from current URL");
	}
	else
	{
		connectSocket();
	}
}

function connectSocket()
{
	if(io != null || io != undefined)
	{
		socket = io.connect(serverURL);
		socket.on('connect', onConnectionEstablished);

		socket.on('message', processMessage);

		/*socket.on('lizzeGame', function(data)
		{
			console.log("lizzeGame: " + data.name);
		});*/

		socket.on('disconnect', function(){});
	}
	else
	{
		console.log("io not loaded.");
	}
}

function manualConnectSocket()
{
	connectSocket();
}

function onConnectionEstablished()
{
	console.log("Connected to socket");
	sendSocketMessage("require", "initData");
}

function sendSocketMessage(parameterName, stringValue)
{
	socket.send("lizzeGame:" + parameterName + "=" + stringValue);
}

function processMessage(message)
{
	var lizzeGameSocketObject = new LizzeGameSocketObject(message);
	
	if(lizzeGameSocketObject.parameterName)
	{
		log(lizzeGameSocketObject.parameterName, lizzeGameSocketObject.stringValue);
		processIncomingLizzeGameSocketObject(lizzeGameSocketObject);
	}
	else
	{
		console.log("Message: " + message);
	}
}

function log(parameter, value)
{
	var logEntries = $("log").getChildren();
	var currentDate = new Date();
	var logContainer = new Element("div", {"class":"logContainer"});
	if(logEntries[0] && logEntries[0].hasClass("logContainerOdd") == false)
	{
		logContainer.addClass("logContainerOdd");
	}
	var logName = new Element("div", {"class":"logName"});
	logName.innerHTML = currentDate.getHours() + ":" + currentDate.getMinutes() + ":" + currentDate.getSeconds() + ":" + currentDate.getMilliseconds() + " " + parameter;
	var logValue = new Element("div", {"class":"logValue"});
	logValue.innerHTML = value;
	
	logName.inject(logContainer);
	logValue.inject(logContainer);
	logContainer.inject($("log"), "top");
	
	if(logEntries.length > maxLogEntries)
	{
		logEntries[logEntries.length - 1].destroy();
	}
}

function processIncomingLizzeGameSocketObject(lizzeGameSocketObject)
{
	switch(lizzeGameSocketObject.parameterName)
	{
		case "require":
			switch(lizzeGameSocketObject.stringValue)
			{
				case "initData":
					sendDummyInitData();
					break;
					
				/*case "lizzeCoopServer":
					sendDummyCoopSever();
					break;*/
			}
			break;
		
		default:
			$(lizzeGameSocketObject.parameterName).innerHTML = lizzeGameSocketObject.stringValue;
			break;
	}
}

function simulateInput(parameterName, stringValue)
{
	var reverseMessageDelay = 1000;
	
	switch(parameterName)
	{
		case "axisHorizontal":
			sendSocketMessage(parameterName, stringValue);
			(function(){sendSocketMessage(parameterName, 0)}).delay(reverseMessageDelay);
			break;
			
			case "axisVertical":
				sendSocketMessage(parameterName, stringValue);
				(function(){sendSocketMessage(parameterName, 0)}).delay(reverseMessageDelay);
				break;
		
		case "playerAttack":
			sendSocketMessage(parameterName, stringValue);
			(function(){sendSocketMessage(parameterName, 0)}).delay(reverseMessageDelay);
			break;
			
		case "playerSpell":
			sendSocketMessage(parameterName, stringValue);
			(function(){sendSocketMessage(parameterName, 0)}).delay(reverseMessageDelay);
			break;

		case "playerSpecialAttack":
			sendSocketMessage(parameterName, stringValue);
			(function(){sendSocketMessage(parameterName, 0)}).delay(reverseMessageDelay);
			break;
		
		case "playerJump":
			sendSocketMessage(parameterName, stringValue);
			(function(){sendSocketMessage(parameterName, "false")}).delay(reverseMessageDelay);
			break;
		
		case "playerSwitch":
			sendSocketMessage(parameterName, stringValue);
			(function(){sendSocketMessage(parameterName, "false")}).delay(reverseMessageDelay);
			break;
	}
}

function simulate(parameterName, stringValue)
{
	switch(parameterName)
	{
		default:
			sendSocketMessage(parameterName, stringValue);
			break;
	}
}

function sendDummyInitData()
{
	sendSocketMessage("lizzeHealth", "63");
	sendSocketMessage("ezzilHealth", "103");
	sendSocketMessage("currentChar", "Lizze");
	sendSocketMessage("lizzeSpell", "true");
	sendSocketMessage("ezzilSpecialAttack", "true");
	sendSocketMessage("lightOfDreamsBlue", "1");
	sendSocketMessage("lightOfDreamsGreen", "2");
	sendSocketMessage("lightOfDreamsRed", "3");
	sendSocketMessage("lightOfDreamsViolett", "4");
	sendSocketMessage("lightOfDreamsYellow", "5");
}

function sendDummyCoopSever()
{
	sendSocketMessage("lizzeCoopServer", "true");
}
























