var serverURL = "http://localhost:3000";
var maxLogEntries = 300;
var autoConnectIntervall = 1500;

var socket;
var io = null;
var autoConnectPeriodical;
var serverOnline = false;

window.addEvent('domready', function()
{
	autoConnectPeriodical = connectSocket.periodical(autoConnectIntervall);
});

function connectSocket()
{
	if(!serverOnline)
	{
		if(io != null || io != undefined)
		{
			try
			{
				socket = io.connect(serverURL);
				socket.on('connect', onConnectionEstablished);
				socket.on('connect_failed', onConnectionFailed);
				socket.on('errors', onSocketErrors);
				socket.on('message', processMessage);

				socket.on('disconnect', function(){});
				console.log("Try to connect at " + serverURL + ".");
			}
			catch(e)
			{}
		}
		else
		{
			var requestSocketIO = new Request({"url":serverURL + "/socket.io/socket.io.js"});
			requestSocketIO.send();
			console.log("io not loaded. Try to reload it ... ");
		}
	}
}

function onConnectionFailed()
{
	console.log("Socket connection failed: ");
}

function onSocketErrors()
{
	console.log("Socket error: ");
}

function onConnectionEstablished()
{
	console.log("Connected to socket at " + serverURL + ".");
	sendSocketMessage("require", "lizzeCoopServer");
}

function sendSocketMessage(parameterName, stringValue)
{
	socket.send("lizzeGame:" + parameterName + "=" + stringValue);
}

function processMessage(message)
{
	var lizzeGameSocketObject = new LizzeGameSocketObject(message);
	
	if(lizzeGameSocketObject.parameterName)
	{
		log(lizzeGameSocketObject.parameterName, lizzeGameSocketObject.stringValue);
		processIncomingLizzeGameSocketObject(lizzeGameSocketObject);
	}
	else
	{
		console.log("Message: " + message);
	}
}

function log(parameter, value)
{
	var logEntries = $("log").getChildren();
	var currentDate = new Date();
	var logContainer = new Element("div", {"class":"logContainer"});
	if(logEntries[0] && logEntries[0].hasClass("logContainerOdd") == false)
	{
		logContainer.addClass("logContainerOdd");
	}
	var logName = new Element("div", {"class":"logName"});
	logName.innerHTML = currentDate.getHours() + ":" + currentDate.getMinutes() + ":" + currentDate.getSeconds() + ":" + currentDate.getMilliseconds() + " " + parameter;
	var logValue = new Element("div", {"class":"logValue"});
	logValue.innerHTML = value;
	
	logName.inject(logContainer);
	logValue.inject(logContainer);
	logContainer.inject($("log"), "top");
	
	if(logEntries.length > maxLogEntries)
	{
		logEntries[logEntries.length - 1].destroy();
	}
}

function processIncomingLizzeGameSocketObject(lizzeGameSocketObject)
{
	switch(lizzeGameSocketObject.parameterName)
	{
		case "lizzeCoopServer":
			setServerStatusOnline(lizzeGameSocketObject.boolValue);
			break;
		
		default:
			//$(lizzeGameSocketObject.parameterName).innerHTML = lizzeGameSocketObject.stringValue;
			break;
	}
}

function setServerStatusOnline(isOnline)
{
	if(isOnline)
	{
		$("serverOnline").style.display = "block";
		$("serverOffline").style.display = "none";
		serverOnline = true;
		clearInterval(autoConnectPeriodical);
	}
	else
	{
		$("serverOnline").style.display = "none";
		$("serverOffline").style.display = "block";
		serverOnline = false;
		autoConnectPeriodical = connectSocket.periodical(autoConnectIntervall);
	}
}

function showLog()
{
	$("showLogButton").style.display = "none";
	$("log").style.display = "block";
	console.log("showlog");
}





















