var serverPort = 3000;
var defaultUri = "/lizzeWebInterface.html";

// Import modules
var http = require("http"),
    path = require("path"),
    url  = require("url"),
    fs   = require("fs"),
    io   = require("socket.io");

// Start server link response function to event
var server = http.createServer(function(request, response) {
  var uri = url.parse(request.url).pathname;
	if(uri == "/")
	{
		uri = defaultUri;
	}

	var filename = path.join(process.cwd(), uri);
  //console.log(filename);
  fs.exists(filename, function(exists) {
    if(!exists) {
      response.writeHead(404, {"Content-Type": "text/plain"});
      response.write("404 Not Found\n");
      response.end();
      return;
    }
    fs.readFile(filename, function(err, file) {
      if(err) {
        response.writeHead(500, {"Content-Type": "text/plain"});  
        response.write(err + "\n");  
        response.end();  
        return;  
      }
      response.writeHead(200, { "Content-Type": "text/html" });  
      response.write(file);
      response.end();
    });
  });
});

server.listen(serverPort);


// Start socket server
var ioListener = io.listen(server);
// Bind handlers to events
ioListener.on('connection', function(socket)
{
	socket.on('message', function (msg)
	{
		if(msg == "lizzeGame:require=lizzeCoopServer")
		{
			// Sends answer to asking client
			socket.send("lizzeGame:lizzeCoopServer=true");
		}
		else
		{
			// Sends message back to all clients
			socket.broadcast.send(msg);
		}
	});
	
	/*socket.on('lizzeGame', function (data)
	{
		// Sends event back to all clients
		socket.broadcast.emit('lizzeGame', data);
		
	});*/
});

console.log("LizzE Coop Server is running at http://127.0.0.1:" + serverPort + "/ (http://localhost:" + serverPort + ")");






















